<?php
/**
 * This file loads content from four different data tables depending on the required time range.
 * The stockquotes table containts 1.7 million data points. Since we are loading OHLC data and
 * MySQL has no concept of first and last in a data group, we have extracted groups by hours, days
 * and months into separate tables. If we were to load a line series with average data, we wouldn't
 * have to do this.
 * 
 * @param callback {String} The name of the JSONP callback to pad the JSON within
 * @param start {Integer} The starting point in JS time
 * @param end {Integer} The ending point in JS time
 */
// get the parameters

require('db.php');
//date_default_timezone_set('America/Toronto');
//$timezoneRequired= date_default_timezone_get();
//$time_now=date('m/d/Y h:i:s a', time());

$callback = $_GET['callback'];



header('Content-Type: text/javascript');

//$batch_id=2;

//$in=$_GET['data'];

if (isset($_GET['data']))
	{
	$in = $_GET["data"];
	}
$start = strtotime(@$_GET['start']);
$end = strtotime(@$_GET['end']);

//echo "/* console.log('Data In = $in, Start = $start, End = $end'); */ \r\n";



if (!$end) $end = time() * 1000;
if (!$start) $start =0;

$data=explode(",",$in);
$tag = rtrim($data[3]);

//echo "/* console.log('Provided Tag = $tag'); */ \r\n";
$mysqli = new mysqli($servername, $username, $password, $dbname);

if ($mysqli->connect_errno) 
	{
    	printf("Connect failed: %s\n", $mysqli->connect_error);
    	exit();
	}
$query="Select * from hc where pass='".$data[0]."' and  chart_id =".$data[1];	
	if ($result = $mysqli->query($query)) 
		{
    		$hc = $result->fetch_assoc();
   		}

$table = $hc['data_table'];



$points =$hc['data'];
$columns=array();
$columns = explode(",",$points);

if($tag){
	$points="$columns[0],$tag";
	$columns = explode(",",$points);}


$where = $hc['sql_where']."".$data[2];
if ($data[2] == null) {
	$where = "1=1";
	 }

// connect to MySQL

$conn = new mysqli($servername, $username, $password, $dbname); 
if ($conn->connect_error) {
  trigger_error('Database connection failed: '  . $conn->connect_error, E_USER_ERROR);
}

$tags =explode (",",$points);
$tag_count = count($tags);

$range = $end - $start;



$sql= "SELECT count(epoch) as records  FROM $table where $where and epoch between '$start' and '$end' order by epoch asc";
//echo "/* console.log('$sql'); */ \r\n";
$result = $conn->query($sql);
$sql_data=$result->fetch_array();
$row_cnt=$sql_data['records'];
//echo "/* console.log('Row Count = $row_cnt'); */ \r\n";

$row_cnt =$row_cnt/50;
$row_offset = Floor($row_cnt);
if ($row_offset==0){$row_offset=1;}

//"/* console.log('Row offset = $row_offset'); */ \r\n";

$arr=array();
$arr2=array();
$tmp_array=array();
$encode=array();
$encode['title']=$hc['title'];
$encode['subtitle']=$hc['subtitle'];
$encode['ytitle']=$hc['ytitle'];
$encode['ytitle2']=$hc['ytitle2'];
$encode['xtitle']=$hc['xtitle'];
$point_count = count($columns);
$row_index=0;
///echo "/* console.log('Row offset = $row_offset'); */ \r\n";


$sql= "SELECT $points  FROM $table where $where and epoch between '$start' and '$end' order by epoch asc";
$sql="SELECT * 
FROM ( SELECT 
        @row := @row +1 AS rownum, $points
    FROM ( SELECT @row :=0) r, $table 
    ) ranked 
WHERE rownum % $row_offset = 1
order by epoch asc";

//echo "/* console.log('$sql'); */ \r\n";
$result = $conn->query($sql);

$data = array();
while ( $row = $result->fetch_assoc() ) {
  $data[] = $row;
}
echo json_encode( $data );


    		
$i=1;

while ($i<$point_count) {
	$sql= "SELECT name,unit,type,cast(valueDecimal as decimal) as valueDecimal,cast(yaxis as decimal) as yaxis from tags where data_table = '$table' and data_point ='$columns[$i]' ";
	//echo "/* console.log('$sql'); */ \r\n";
	$rs2=$conn->query($sql);
	$arr2 = $rs2->fetch_array(MYSQLI_ASSOC);
	//$arr2['xaxis']=$arr['xaxis'];
	$arr2['data']=$arr[$i];
	$arr2['valueDecimals']=2;
	$encode['datasets'][]=$tmp_array;
	$i++;
	}




//echo $_GET['callback']. '('. json_encode($tmp_array) . ')';   
mysqli_close($conn);
?>