<?php
//ini_set('display_errors', 1);
//echo"Start Google  ".__DIR__."\n";
require __DIR__ .'/vendor/autoload.php';
//echo"Require Complete  ".__DIR__."\n";

//if (php_sapi_name() != 'cli') {
//    Echo"Not Command Line";
//    throw new Exception('This application must be run on the command line.');
//}


//Make sure that it is a POST request.
if(strcasecmp($_SERVER['REQUEST_METHOD'], 'POST') != 0){
    echo "Post Not Detected";
    throw new Exception('Request method must be POST!');
}
 
//Make sure that the content type of the POST request has been set to application/json
$contentType = isset($_SERVER["CONTENT_TYPE"]) ? trim($_SERVER["CONTENT_TYPE"]) : '';
if(strcasecmp($contentType, 'application/json') != 0){
    Echo"Content Not Json";
    throw new Exception('Content type must be: application/json');
}
 
//echo "Receive the RAW post data.\n";
$content = trim(file_get_contents("php://input"));
//echo "Content = ". $content ; 
//Attempt to decode the incoming RAW post data from JSON.
$decoded = json_decode($content,true);
//echo "\ndecode\n";
//var_dump($decoded);
//echo"end of decode /n";
//echo ($decoded["description"]);
//If json_decode failed, the JSON is invalid.


if(!is_array($decoded)){
    throw new Exception('Received content contained invalid JSON!');
}


//$data = json_decode($_Post);
//var_dump($data);
//Var_dump($_post);







/**
 * Returns an authorized API client.
 * @return Google_Client the authorized client object
 */


function getClient()
{
    Echo"New Client \n";
    $client = new Google_Client();
    echo"New Client Created \n";
    $client->setApplicationName('Google Calendar API PHP Quickstart');
    $client->setScopes(Google_Service_Calendar::CALENDAR);
    $client->setAuthConfig('credentials.json');
    $client->setAccessType('offline');

    // Load previously authorized credentials from a file.
    $credentialsPath = 'token.json';
    if (file_exists($credentialsPath)) {
        echo "Credentials Exist\n";
        $accessToken = json_decode(file_get_contents($credentialsPath), true);
    } else {
        // Request authorization from the user.
        $authUrl = $client->createAuthUrl();
        echo "New KEY";
        printf("Open the following link in your browser:\n%s\n", $authUrl);
        print 'Enter verification code: ';
        $authCode = trim(fgets(STDIN));

        // Exchange authorization code for an access token.
        $accessToken = $client->fetchAccessTokenWithAuthCode($authCode);

        // Check to see if there was an error.
        if (array_key_exists('error', $accessToken)) {
            echo "Key Exists";
            throw new Exception(join(', ', $accessToken));
        }

        // Store the credentials to disk.
        if (!file_exists(dirname($credentialsPath))) {
            echo "Credentials ".$credentialsPath."\n";
            mkdir(dirname($credentialsPath), 0700, true);
        }
        file_put_contents($credentialsPath, json_encode($accessToken));
        printf("Credentials saved to %s\n", $credentialsPath);
    }
    $client->setAccessToken($accessToken);

    // Refresh the token if it's expired.
    if ($client->isAccessTokenExpired()) {
        echo"Token Expired  ".$credentialsPath."\n";
        $client->fetchAccessTokenWithRefreshToken($client->getRefreshToken());
        file_put_contents($credentialsPath, json_encode($client->getAccessToken()));
    }
    return $client;
}


// Get the API client and construct the service object.
echo "Getting Client\n";
$client = getClient();
$service = new Google_Service_Calendar($client);

echo "Connect Service\n";

// Print the next 10 events on the user's calendar.
$calendarId = 'primary';
$optParams = array(
  'maxResults' => 10,
  'orderBy' => 'startTime',
  'singleEvents' => true,
  'timeMin' => date('c'),
);
$results = $service->events->listEvents($calendarId, $optParams);
$events = $results->getItems();

if (empty($events)) {
    print "No upcoming events found.\n";
} else {
    print "Upcoming events:\n";
    foreach ($events as $event) {
        $start = $event->start->dateTime;
        if (empty($start)) {
            $start = $event->start->date;
        }
        printf("%s (%s)\n", $event->getSummary(), $start);
    }
}


$event = new Google_Service_Calendar_Event(array(
  'summary' => $decoded["summary"],
  'location' => '',
  'description' => $decoded["description"],
  'colorId' => $decoded["colorid"],
  'start' => array(
    'dateTime' => $decoded["start"]["DateTime"],
    'timeZone' => $decoded["start"]["timezone"],
  ),
  'end' => array(
    'dateTime' => $decoded["end"]["DateTime"],
    'timeZone' => $decoded["end"]["timezone"],
  ),



));

echo"Start Create \n";
//var_dump($event);
$calendarId = $decoded["target"];


echo"Target ".$calendarId."\n";
$event = $service->events->insert($calendarId, $event);
echo" Event:".$event."\n";
printf('Event created: %s\n', $event->htmlLink);
//echo "Event created\n".$event->htmlLink."\n";

